--[[---------------------------------------------------------------------------
	Chocolatier Two Port Data: Cayenne
	Copyright (c) 2007 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

-------------------------------------------------------------------------------
-- Characters

DefineCharacter { name = "cay_marketkeep" }
DefineCharacter { name = "cay_farmkeep" }
DefineCharacter { name = "cay_isleskeep" }
DefineCharacter { name = "cay_barkeep" }
DefineCharacter { name = "cay_hotelkeep" }
DefineCharacter { name = "cay_shopkeep" }
-------------------------------------------------------------------------------
-- Port Definition

DefinePort
{
	name = "cayenne",
	available = false,
	ambient="sfx/seaside_loop.ogg",

	layout =
	{
		-- Clouds
		SpriteLayer { image="clouds_03", time=180000, loop=true, htile=true, path={{0,40},{100,40},{700,40},{800,40}}, },
		
		-- far Boats
		SpriteLayer { imagelist=portBoats, scale=.2, time=150000, bounce=true, hold=8000,
			path={ {-80,86},{100,86},{750,86},{880,86} } },
			
		--island
		GenericBuilding { name="cay_isles", character = "cay_isleskeep", x=0+509/2,y=6+114/2, },
		
		--near canoe
		SpriteLayer { image="boat_06", scale=.15, time=90000, bounce=true, hold=8000,
			path={{-90,130},{96,120},{756,115},{893,113},}, },
		
		
		SpriteLayer { image="cay_islesmask", x=0+800/2,y=97+88/2, },
		Market { name="cay_farm", character="cay_farmkeep", x=224+228/2,y=121+106/2,
			ambient = "sfx/farm_loop.ogg",
			inventory = { ca_cacao=true, }, dialog="farm_cayenne", },
		SpriteLayer { image="cay_farmmask", x=168+326/2,y=97+154/2, },
		EmptyBuilding { name="cay_hotel", character = {"cay_hotelkeep"}, ambient="sfx/other_loop.ogg", x=11+272/2,y=169+204/2, },
		EmptyBuilding { name="cay_bar", character = {"cay_barkeep"}, x=256+241/2,y=219+152/2, ambient="sfx/saloon_loop.ogg" },
		Market { name="cay_market", character="cay_marketkeep", x=489+176/2,y=124+249/2, labelx=540,labely=225,
			inventory = { milk=true, cacao=true, pepper=true, sugar=true, coffee = true,} },
		Shop { name="cay_shop", character="cay_shopkeep", x=635+165/2,y=165+202/2, },
		SpriteLayer { image="cay_marketmask", x=457+343/2,y=342+54/2, },
		
		-- Vehicles
		SpriteLayer { imagelist=portCars, scale=.9, time=16000, bounce=true, hold=4000,
			path={{-71,361},{401,367},{746,390},{886,395},}, },
			
		SpriteLayer { imagelist=portCars, scale=.9, time=14000, bounce=true, hold=3000,
			path={{882,414},{700,407},{124,363},{-69,378},}, },
		
		SpriteLayer { image="cay_roadmask", x=0+313/2,y=87+332/2, },
		SpriteLayer { image="cay_palm", x=604+196/2,y=0+476/2, },
	}
}
